/****************************************************************************
**
** Copyright (C) 2017 The Qt Company Ltd.
** Contact: http://www.qt-project.orgrg/legal
**
** This file is part of the examples of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:BSD$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** BSD License Usage
** Alternatively, you may use this file under the terms of the BSD license
** as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of The Qt Company Ltd nor the names of its
**     contributors may be used to endorse or promote products derived
**     from this software without specific prior written permission.
**
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick 2.0
import QtWayland.Compositor 1.3
import editec.base 1.0

WaylandCompositor {
    id: waylandCompositor
    property int counter :0
    property var screen1;
    property var screen2;
    property string use_disp;
    property string tpm_type;
    property var screens: [];
    property bool zygoterunning :false;

    //Screen { id: screen2;source: "qrc:/images/background.jpg";uid : 1; compositor: waylandCompositor }
    //Screen { id: screen1;source: "qrc:/images/background.jpg";uid : 0; compositor: waylandCompositor }

    // Shell surface extension. Needed to provide a window concept for Wayland clients.
    // I.e. requests and events for maximization, minimization, resizing, closing etc.
    /*
    Loader {
            anchors.fill: parent
            source: "Keyboard.qml"
    }
    */
    Gpqml {
	    id: gpqml
    }
    
    Connections {
        target: gpqml
        onSig_raise_window: {
            var s  = winname+"##DISPLAY_ID=1";
            var uid;

            uid = screen1.is_window_active(winname,appname);
            if (uid == 0)
			    screen1.raise_window(winname,appname);
            else if (use_disp >= 3){
                s = winname+"##DISPLAY_ID=2";
                uid = screen2.is_window_active(winname,appname);
                if (uid == 1)
                   screen2.raise_window(winname,appname);
            }
        }
	    onSig_compositor_wakeup: {
			screen1.screen_touched();
            if (use_disp >= 3)
              screen2.screen_touched();
		}
        onSig_take_screenshot: {
			screen1.take_screenshot();
		}
	    onSig_update_window_pid_info: {
			screen1.update_window_pid_info(pid,url);
            if (use_disp >= 3)
              screen2.update_window_pid_info(pid,url);
		}
	}
    onZygoterunningChanged : {
        screen1.zygoterunning = zygoterunning;
        if (use_disp >= 3)
           screen2.zygoterunning = zygoterunning;
    }
    XdgShell {
        onToplevelCreated: {
	    handleShellSurfaceCreated(xdgSurface)
	    xdgSurface.toplevel.titleChanged.connect(function onTitleChagedT(){onTitleChaged(xdgSurface)});
	    }
	    onXdgSurfaceCreated: {
	    }
        onPopupCreated: {
	    }
    }
    // Unstable version of xdg-shell still used by some clients
    
    XdgShellV6 {
        onToplevelCreated: {
	    handleShellSurfaceCreated(xdgSurface)
	    xdgSurface.toplevel.titleChanged.connect(function onTitleChagedT(){onTitleChaged(xdgSurface)});
	}
	onXdgSurfaceCreated: {
	}
    onPopupCreated: {
	}
    }
    
    // Deprecated shell extension, still used by some clients
    /*
      WlShell {
        onWlShellSurfaceCreated: handleShellSurfaceCreated(shellSurface)
    }
    */
    // Extension for Virtual keyboard support
    TextInputManager {}
    function handleShellSurfaceCreated(shellSurface) {
	    console.log ("handleShellSurfaceCreated " + shellSurface.toplevel.title);
    }
    function  onTitleChaged(xdgSurface) {
       var i = 0;     
       var s;
       var l=[];
       var display_id = -1;
       if (xdgSurface.toplevel.title != null)
	        s = xdgSurface.toplevel.title;

        console.log("title " + s + " t "+ xdgSurface.windowGeometry + " use_disp " + use_disp + " appid " + xdgSurface.appId);
        
       
       /*
       if (s.includes("Untitled ")){//first surface of Chromium ,why ???
	      return;
       }
       */
       if (xdgSurface.windowGeometry.width >0 && xdgSurface.windowGeometry.height > 0){//title change no need for new window
              print("ignoring title change");
    	      return;
       }
       if (use_disp < 3){
	       screen1.handleShellSurface(xdgSurface,screens);
	       return;
       } 
       l = s.split("##DISPLAY_ID=");
       if (l.length > 1){
    	    display_id = parseInt(l[1]);
    	    print("display_id =",display_id)
       }

       if ( display_id != 1 && (display_id == 2 || s.includes("tpm_") || s.includes("game_plugin") || /*s.includes("video") || s.includes("camera") ||*/ s == "" || s.includes("Chromi"))){
	    screen2.handleShellSurface(xdgSurface,screens);//screen2
       }
       else
	    screen1.handleShellSurface(xdgSurface,screens);
    }
	function raise_window(winname,appname,display_id)
	{
		var s  = winname+"##DISPLAY_ID=1";
		var uid=-1;

		uid = screen1.is_window_active(winname,appname);
		if (uid == 0)
			screen1.raise_window(winname,appname);
		else if (use_disp >= 3){
			s = winname+"##DISPLAY_ID=2";
			uid = screen2.is_window_active(winname,appname);
			if (uid == 1)
				screen2.raise_window(winname,appname);
		}
		return uid;
    }
	function delete_window(winname)
    {
		var i = 0,j = 0;

		print("deleting window ", winname);
		for (j=0;j < screens.length;j++){
			for (i=0;i < screens[j].shellSurfaces.count;i++){
             print("Title before del1 ", screens[j].shellSurfaces.get(i).shellSurface.toplevel.title, " ", screens[j].shellSurfaces.get(i).title);
             if (screens[j].shellSurfaces.get(i).shellSurface.toplevel.title.includes(winname) || screens[j].shellSurfaces.get(i).title.includes(winname)){//stage-di-dashboard
               screens[j].shellSurfaces.remove(i);					                   
               print("deleting site");
               break;
            }
          }
		}	
    }
	function show_panel(isshow,display_id,height)
    {
		var j = 0;

		for (j=0;j < screens.length;j++){
			if (j == (display_id-1) || display_id == -1){
				if (height > 0 && isshow)
					screens[j].bottomh = height;
				screens[j].show_panel(isshow);
			}
		}
    }
    function configure_lockscreen(username,timeout)
    {
		var j = 0;

		for (j=0;j < screens.length;j++){			
				screens[j].configure_lockscreen(username,timeout);
		}
    }
    Component.onCompleted : {

    }
    onUse_dispChanged : {
	    print("use_disp ", use_disp)
	    screen1 = Qt.createQmlObject('import QtQuick 2.0;import QtWayland.Compositor 1.3;Screen {id: output; source: "qrc:/images/background.jpg";uid : 0;/*position: Qt.point(0, 0);*/ compositor: waylandCompositor }',waylandCompositor);
	    screens[0] = screen1;
        screens[0].tpm_type = tpm_type; 
	    if (use_disp >= 3){
	        screen2 = Qt.createQmlObject('import QtQuick 2.0;import QtWayland.Compositor 1.3;Screen {id: output;  source: "qrc:/images/background.jpg";uid : 1;/*position: Qt.point(800, 0);*/ compositor: waylandCompositor }',waylandCompositor);
	        screens[1] = screen2;
            screens[1].tpm_type = tpm_type; 
	    }
    }
}
