import QtQuick 2.15
import QtQuick.Window 2.15

import "."


MultiPointTouchArea {
    property int tpid: 0
    property int tpy: 1000
    property int sz: 0
    property int direction : 0
    anchors.fill: parent
    
    signal sizeChanged(int w,int h);
    onPressed: {
            for (var touch in touchPoints){
                //console.log("Multitouch pressed", touchPoints[touch].pointId, "at", touchPoints[touch].x, ",", touchPoints[touch].y)
                tpid = touchPoints[touch].pointId;
                tpy = touchPoints[touch].y;
        	break;
            }
    }
    onReleased: {
            for (var touch in touchPoints){
                //console.log("Multitouch released", touchPoints[touch].pointId, "at", touchPoints[touch].x, ",", touchPoints[touch].y)
                if (tpid == touchPoints[touch].pointId || tpid == -1){
        	    if (direction == 1 && tpy - touchPoints[touch].y >= bottomh/3 && tpy >= (Screen.height - bottomh)){
            		//print("swipe up detected");
            		//parent.z = -1000//sz
            		sizeChanged(Screen.width,Screen.height);
            		break;
            	    }
        	    if (direction == 0 && touchPoints[touch].y -tpy >= bottomh/3){
            		//print("swipe down detected");
            		//parent.z = -1000//sz
            		sizeChanged(Screen.width,Screen.height - bottomh);
            		break;
            	    }
                }
	    }
    }
}
