/****************************************************************************
**
** Copyright (C) 2017 The Qt Company Ltd.
** Contact: http://www.qt-project.org/legal
**
** This file is part of the examples of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:BSD$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** BSD License Usage
** Alternatively, you may use this file under the terms of the BSD license
** as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of The Qt Company Ltd nor the names of its
**     contributors may be used to endorse or promote products derived
**     from this software without specific prior written permission.
**
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick 2.5
import QtQuick.Window 2.2
import QtWayland.Compositor 1.0
import QtQuick.Controls 2.15

WaylandOutput {
    id: output
    sizeFollowsWindow: true
    property int uid;
    property var screens : []
    property alias source : background.source
    property alias x: wnd.x
    property alias y: wnd.y
    property ListModel shellSurfaces: ListModel {}
    property ListModel ss: ListModel {}
    property bool isNestedCompositor: Qt.platform.pluginName.startsWith("wayland") || Qt.platform.pluginName === "xcb"
    property bool istopa : false
    
    function handleShellSurface(shellSurface,screensi) {
	var i = 0;
	var nb_a = 0;
	var isa = false;
	var isfirsta = false;
	
	screens = screensi;
        for (i=0;i < output.shellSurfaces.count;i++){
    	     var app = output.shellSurfaces.get(i).shellSurface.toplevel.appId;
    	     if (output.shellSurfaces.get(i).shellSurface.toplevel.title.includes(".") ||
    	        (app != undefined && app.includes("android"))){
    		print("prev ", output.shellSurfaces.get(i).shellSurface.toplevel.title);
    		output.shellSurfaces.get(i).shellSurface.toplevel.sendConfigure(Qt.size(0,0),[-1,-2]);
    		nb_a = nb_a + 1;
    	     }
        }
        if (shellSurface.toplevel.title.includes(".") ||(app != undefined && app.includes("android"))){
    	    isa = true;
    	    if (nb_a == 0){
    		isfirsta = true;
    		output.istopa = true;
    	    }
	}
        output.shellSurfaces.append({"shellSurface": shellSurface,"isfullscreen": false,
    	    "isa": isa,"isfirsta": isfirsta,"title": shellSurface.toplevel.title});
        output.ss.append({"shellSurface": shellSurface,"isfullscreen": false,
    	    "isa": isa,"isfirsta": isfirsta,"title": shellSurface.toplevel.title});
    }

    // During development, it can be useful to start the compositor inside X11 or
    // another Wayland compositor. In such cases, set sizeFollowsWindow to true to
    // enable resizing of the compositor window to be forwarded to the Wayland clients
    // as the output (screen) changing resolution. Consider setting it to false if you
    // are running the compositor using eglfs, linuxfb or similar QPA backends.
    //sizeFollowsWindow: output.isNestedCompositor

    window: Window {
	id: wnd
        //width: 1024
        //height: 768
        visible: true

        WaylandMouseTracker {
            id: mouseTracker
            anchors.fill: parent

            // Set this to false to disable the outer mouse cursor when running nested
            // compositors. Otherwise you would see two mouse cursors, one for each compositor.
            windowSystemCursorEnabled: output.isNestedCompositor

            Image {
                id: background

                anchors.fill: parent
                fillMode: Image.Tile
                //source: "qrc:/images/background.jpg"
                smooth: true

                Repeater {
                    model: output.shellSurfaces
                    id: rep
                    // Chrome displays a shell surface on the screen (See Chrome.qml)
                    Chrome {
                	bottombtn : db
                	uid : output.uid
                        shellSurface: model.shellSurface//modelData
                        onDestroyAnimationFinished: {
                    	    var i = 0;
			    var id = index;
			    var shs = output.shellSurfaces;
			    var index1 = -1;
			    var index2 = -1;
			    var title;
			    
			    print("v ",id,shs.get(id).title);
			    title = shs.get(id).title;
			    
			    for (i=0;i < shs.count;i++){
			        if (title==output.ss.get(i).title){
			    	    index1 = i;
				    break;
				}
			    }
                    	    shs.remove(id);
                    	    output.ss.remove(index1);
			    for (i=0;i < shs.count;i++){
			        if (shs.get(shs.count-1).title==output.ss.get(i).title){
			    	    index2 = i;
				    break;
				}
			    }
                    	    output.ss.move(index2,shs.count-1,1);
                    	    print("remove ",shs.count);
                    	    for (i=shs.count-1; i>=0;i--) {
                    		var app;
                    		var shse = shs.get(i);
                    		print("remove1 ",shse.shellSurface);
                    		if (shse.shellSurface == undefined){
				    continue;
                    		}
                    		app = shse.shellSurface.toplevel.appId;
                    		if (shse.title.includes(".") ||
                    		    (app != undefined && app.includes("android"))){
				    shse.shellSurface.toplevel.sendConfigure(Qt.size(0,0),[-3,-4]);
				}
				print("new top ",shse.title,shse.isfullscreen)
				if (!shse.isfullscreen){
				    bottombtn.height = 100;
				}
				else {
				    bottombtn.height = 0;
				}
				if (shse.isfirsta)
				    output.istopa = true;
				else
				    output.istopa = false;
				break;
			    }
                    	}
                    	Component.onCompleted : {
                    	    model.isfullscreen = isfullscreen;
			}
                    }
                }
            	BottomButtonsBg {
				id: db
				anchors.bottom: background.bottom
				
				transform: Scale {xScale: 800/600;/*yScale: 1280/1024;*/origin.y: background.height}
				ButtonBottom {
					y: 0//15
					x: 25
					face: "back"
					onClicked: {

					}
				}
				ButtonBottom {
					y: 0//15
					x: 405
					face: "abort"
					
					onClicked: {
					    var shs = output.shellSurfaces;
					    var ss = output.ss;
					    var app;
					    var isandroidstack = false;
					    var i;
					    var j;
					    var needna = false;
					    var nbm = 1;
					    var rshs = null;
					    
					    for (i=0;i < shs.count; i++) {
						if (shs.get(i).shellSurface.toplevel.title.includes("android") &&
						    shs.get(i).shellSurface.toplevel.title.includes("##1")){
						    isandroidstack = true;
						    break;
						}
					    }
					    print("nb surface ",output.shellSurfaces.count);
					    //print("surface os ",output.screens[1-uid].output.shellSurfaces.get(0).shellSurface.toplevel.title)
					    if (ss.count>=2 && ss.get(shs.count-1).isa && ss.get(shs.count-2).isa){
						if (ss.get(shs.count-2).isfirsta){
						    rshs = ss.get(shs.count-2).shellSurface;
						    nbm = 0;
						
						    if (!output.istopa)
							shs.move(shs.count-1,0,1);
						    ss.move(shs.count-1,0,1);
						    output.istopa = true;
						    print ("no need to move2");
						}
					    }
					    if (ss.count>=2 && nbm && ss.get(shs.count-2).isa && !ss.get(shs.count-2).isfirsta){
						needna = true;
						print ("need another android surf");
						rshs = ss.get(shs.count-2).shellSurface;
						if (output.istopa){
						    nbm = 0;
						    ss.move(shs.count-1,0,1);
						    print ("no need to move1");
						}
					    }
					    for (i=shs.count-2;i >= 0 && nbm; i--) {
						print("surface m ",ss.get(i).shellSurface.toplevel.title);
						output.istopa = false;
						if (needna && (!ss.get(i).isfirsta || !ss.get(i).isa)){
						    nbm = nbm + 1;
						    continue;
						}
						print("surface move ",nbm);
						
						ss.move(shs.count-nbm,0,nbm);
						for (j=0;j <= shs.count - 2;j++){
						    shs.move(shs.count-1,0,1);
						    if (ss.get(shs.count-1).shellSurface.toplevel.title==shs.get(shs.count-1).shellSurface.toplevel.title)
							break;
						}
						print("surface  ",ss.get(shs.count-1).shellSurface.toplevel.title);
						if (needna == false)
						    rshs = ss.get(shs.count-1).shellSurface;
						if (ss.get(shs.count-1).shellSurface.toplevel.title.includes("tpm_statusDlg"))
						    continue;
						if (isandroidstack && ss.get(shs.count-1).shellSurface.toplevel.title.includes("##0"))
						    continue;
						if (ss.get(shs.count-1).isfirsta)
						    output.istopa = true;
						break;
					    }
					    if (rshs != null){
						for (j=0;j < nbm;j++)
						    shs.get(j).shellSurface.toplevel.sendConfigure(Qt.size(0,0),[-1,-2]);
						app = rshs.toplevel.appId;
						print("top surface ",rshs.toplevel.title,"/",app)
						if (rshs.toplevel.title.includes(".") ||
						    (app!=undefined && app.includes("android"))){
						    rshs.toplevel.sendConfigure(Qt.size(0,0),[-3,-4]);
						}
					    
						if (!shs.get(shs.count-1).isfullscreen){
					    	    db.height = 100;
						}
						else {
					    	    db.height = 0;
						}
					    }
					}
				}
		   }
            }

            // Virtual Keyboard
            Loader {
                anchors.fill: parent
                source: "Keyboard.qml"
            }

            // Draws the mouse cursor for a given Wayland seat
            /*
            WaylandCursorItem {
                inputEventsEnabled: false
                x: mouseTracker.mouseX
                y: mouseTracker.mouseY
                seat: output.compositor.defaultSeat
            }
            */
        }

        Shortcut {
            sequence: "Ctrl+Alt+Backspace"
            onActivated: Qt.quit()
        }
    }
}
