/****************************************************************************
**
** Copyright (C) 2017 The Qt Company Ltd.
** Contact: http://www.qt-project.org/legal
**
** This file is part of the examples of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:BSD$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** BSD License Usage
** Alternatively, you may use this file under the terms of the BSD license
** as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of The Qt Company Ltd nor the names of its
**     contributors may be used to endorse or promote products derived
**     from this software without specific prior written permission.
**
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick 2.15
import QtQuick.Window 2.15
import QtWayland.Compositor 1.0
import QtQuick.Controls 2.15
import editec.base 1.0

WaylandOutput {
    id: output    
    property int uid;
    property var screens : []
    property alias source : background.source
    property bool isNestedCompositor: Qt.platform.pluginName.startsWith("wayland") || Qt.platform.pluginName === "xcb"
    sizeFollowsWindow: true
    property int gwidth:  ScaleE.gwidth
    property int gheight: ScaleE.gheight
    property alias x: wnd.x
    property alias y: wnd.y
    property ListModel shellSurfaces: ListModel {}   
    property bool istopa : false
    property int  bottomh : 80
    property double startTime: 0
    property bool issleep : false
    property int  confcount : 100//not to mix with ackconfigure values which are now 1 - 8
	  property int  state_take_focus: 5
    property bool android_ui_active : false
    property string launcher : "com.android.launcher3"
    property string asettings : "com.android.settings"
    property string waydroid : "Waydroid"
    property string cmdl : ""
    property string appnamel : ""
    property string title_tmp : ""
    property bool android_ui_startup : false
    property var mobj :null
    property int sleep_ival :70
    property int count_destroy: 0
	  property bool hide_launcher : true
	  property int  backlight_interval : 0
	  property int  backlight_normal : 127
	  property string cur_title : "";   
	  property bool is_android_ui_first_window : true;
    property bool is_shown_launcher : false;
    property bool is_shown_asettings : false;
    property bool zygoterunning : false;
    property string tpm_type;
    property string  defusername: "";
    property int     deflock_interval;
    property var arrdf: []
    property var arrdynb: []
    property var arrpidinfo: []
	  property var defaultseat
    signal sizeChanged(int w,int h,int direction);
    signal androidReady();
    signal show_panel(bool isshow);
    Timer {
	    id: tmr
        triggeredOnStart: true
        interval: 5000
        running:  false//true
        repeat:   true
        onTriggered: {
		    var diff;
		    var ctime = new Date().getTime();
    		diff = ctime - startTime;
			//print ("timer ",diff," uid ",uid,backlight_interval);
    		//startTime = ctime;
    		if (diff >backlight_interval){
    		    gpqml.set_brightness(output.uid,0);                
    		    issleep = true;
    		}
            if (defusername != "" && deflock_interval > 0){
               if (diff >deflock_interval){
                    showlogin();   
               }
            }
        }
    }
	
    onZygoterunningChanged : {
        print ("zygoterunning1 ",zygoterunning);
        if (zygoterunning)
          run_android_process_common("","");
    }
	Timer {
	    id: delayCallerComponent;
	}
    Component.onCompleted : {	    
		if (gpqml.get_config("hide_launcher","") == "false")
			hide_launcher = false;
		else
		    hide_launcher = true;
        bottomh = parseInt(gpqml.get_config("panel_height","100"));
        gpqml.set_prop("compositor.panel.height",gpqml.get_config("panel_height","100"));
		backlight_interval = parseInt(gpqml.get_config("backlight_interval",""));
        deflock_interval = backlight_interval + 2000;
		backlight_normal = parseInt(gpqml.get_config("backlight_normal",""));
		if (backlight_interval > 0){
			tmr.running = true;
			issleep = true;
		}
        arrdf = gpqml.load_desktop_files(uid + 1);
		print ("pars ",hide_launcher,backlight_interval,backlight_normal)
		screen_touched();
    }
    function configure_lockscreen(username,timeout)
    {
        defusername = username;
        deflock_interval = timeout;
        if (defusername == "")
           hidelogin();
    }
    function screen_touched()
    {
    	startTime = new Date().getTime();
    	if (issleep)
			gpqml.set_brightness(output.uid,backlight_normal);
    	issleep = false;
    }
    //dbus-send --system --print-reply=literal  --dest=org.editec.compositor /compositor  run.compositor.raise_window string:"premierbet" string:"" int32:-1
    function raise_window(winname,appname)
	{
		process(false,winname,appname);
	}
	function take_screenshot()
    {
        var l = [];
        var j;
        for (j=0;j < output.screens.length; j++){
           l.push(output.screens[j].window);
        }
        gpqml.screenshot(l);					    
    }
    function update_window_pid_info(pid,url)
    {
        print("update_window_pid_info",url,pid);        
        for (var i=0;i < arrpidinfo.length; i++){          
           if (arrpidinfo[i].pid == pid)
             return;
           if (arrpidinfo[i].url == url){
              print("updating pid old ",arrpidinfo[i].pid," new ",pid);
              arrpidinfo[i].pid = pid;
              return;
           }
        }
        if (pid > 0)
          arrpidinfo.push({"pid": pid, "url": url});
    }
    function suspend_window(surface,issuspend)
    {
        //print("suspend_window ",issuspend,surface.shellSurface.toplevel.title, surface.title, " arrdf length ", arrdf.length);        
        for (var i=0;i < arrdf.length; i++){
          if (arrdf[i].issuspendbackground && (surface.shellSurface.toplevel.title.includes(arrdf[i].raise_app) || surface.title.includes(arrdf[i].raise_app))){
              //print("found desktop file with " , arrdf[i].raise_app);
              for (var j=0;j < arrpidinfo.length; j++){
                 print("pid ",arrpidinfo[j].pid,arrpidinfo[j].url,arrpidinfo[j].url.includes(arrdf[i].raise_app) );
                 if (arrpidinfo[j].pid > 0 && (arrpidinfo[j].url.includes(arrdf[i].raise_app))){
                    print("found suspend url  " , arrpidinfo[j].url , " with pid " , arrpidinfo[j].pid);
                    gpqml.suspend_process(arrpidinfo[j].pid,issuspend);
                    return;
                 }
              }
              return;
          }
        }
    }
    function kill_window(i)
    {
        if (i < 0 || i >= arrdf.length)
           return;
        if (output.shellSurfaces.count > 0)
           print("killing ", output.shellSurfaces.get(output.shellSurfaces.count-1).shellSurface.toplevel.title,arrdf[i].raise_app);
        if (arrdf[i].exec_kill_window){
             if (output.shellSurfaces.count > 0 && (output.shellSurfaces.get(output.shellSurfaces.count-1).shellSurface.toplevel.title.includes(arrdf[i].raise_app) || output.shellSurfaces.get(output.shellSurfaces.count-1).title.includes(arrdf[i].raise_app))){
               output.shellSurfaces.get(output.shellSurfaces.count-1).shellSurface.toplevel.sendClose();               
             }
             return;//exit even if window not found / we can press button of not top app
        }
        if (arrdf[i].exec_kill != ""){
             /*
             for (var j=0;j < arrpidinfo.length; j++){
                if (arrpidinfo[j].pid > 0 && (arrpidinfo[j].url.includes(arrdf[i].raise_app))){
                  gpqml.kill_process(arrpidinfo[j].pid);
                  return;
                }
              }
           */
                gpqml.run_process(arrdf[i].exec_kill,arrdf[i].raise_app,"",-1);
        }
    }
	  function setdefaultseat(seat)
	  {
			defaultseat = seat;
		}
    function handleShellSurface(shellSurface,screensi)
    {
	    var i = 0;
	    var nb_a = 0;
	    var isa = false;
	    var isfirsta = false;
        var isignoretoppanel = false;
		var app;

		if (shellSurface.toplevel.title.includes("_replace")){		
			return;
		}
	    screens = screensi;
        for (i=0;i < output.shellSurfaces.count;i++)
        {
    	    app = output.shellSurfaces.get(i).shellSurface.toplevel.appId;
    	    if (is_window_android(output.shellSurfaces.get(i).shellSurface.toplevel.title,app))
            {
    	        print("android prev ", output.shellSurfaces.get(i).shellSurface.toplevel.title);
    	        output.shellSurfaces.get(i).shellSurface.toplevel.sendConfigure(Qt.size(0,0),[-1,-2,++output.confcount]);
    	        nb_a = nb_a + 1;
    	    }
        }
		app = shellSurface.toplevel.appId;
        if (is_window_android(shellSurface.toplevel.title,app))
        {
    	    isa = true;
    	    if (nb_a == 0){
    		    isfirsta = true;
    		    output.istopa = true;
    	    }
	    }  
	    for (var i=0;i < arrdf.length; i++){
           if (shellSurface.toplevel.title.includes(arrdf[i].raise_app)){
               isignoretoppanel = arrdf[i].isignoretoppanel;
               break;
           }
        }
        {
            if (isa)
				shellSurface.toplevel.sendConfigure(Qt.size(0,0),[-3,-4,++output.confcount]);
			if (!hide_launcher || !shellSurface.toplevel.title.includes(launcher)){//if want to hide launcher
			if ((is_android_ui_first_window ||
            (!is_shown_launcher && shellSurface.toplevel.title.includes(launcher)) ||
            //(!is_shown_launcher && shellSurface.toplevel.title.includes(waydroid)) ||
            (!is_shown_asettings && shellSurface.toplevel.title.includes(asettings)) ) && isa){
					print("android_ui_first_window " + shellSurface.toplevel.title);//first android window after startup doest not move back when we switch with next btn so we will prepend
					output.shellSurfaces.insert(0,{"shellSurface": shellSurface,"isfullscreen": false,
			        "isa": isa,"isfirsta": isfirsta,"title": shellSurface.toplevel.title,"isignoretoppanel":isignoretoppanel});

                   
                    if (shellSurface.toplevel.title.includes(launcher))
                       is_shown_launcher = true;
                    if (shellSurface.toplevel.title.includes(asettings))
                      is_shown_asettings = true;
					is_android_ui_first_window = false;
					delayCallerComponent.interval = 1000;
					delayCallerComponent.repeat = false;
					delayCallerComponent.triggered.connect(function () {print ("delayed switch"); process(true,"","");});//true
					delayCallerComponent.start();
				}
				else {                    
					output.shellSurfaces.append({"shellSurface": shellSurface,"isfullscreen": false,
					"isa": isa,"isfirsta": isfirsta,"title": shellSurface.toplevel.title,"isignoretoppanel":isignoretoppanel});                                       
                    
          print("adding ", shellSurface.toplevel.title,"isa",isa);
				}
			}		
        }
       
    	if (shellSurface.toplevel.title.includes(launcher) || shellSurface.toplevel.title == waydroid)//as soon as it appears
        {
            print("run android_ui_startup false 1");
            run_really_android_process();
    	}
        
	    cur_title = shellSurface.toplevel.title;
        for (var i=0;i<=output.shellSurfaces.count-2; i++) {
            suspend_window(output.shellSurfaces.get(i),true);
        }

			shellSurface.toplevel.sendConfigure(Qt.size(0,0),[state_take_focus]);//XdgToplevel::activated
    }
    
    function notify_resize(h)
    {
	    var shs = output.shellSurfaces;
	    var j;
	    
		
	    for (j=shs.count-1;j >= 0;j--)
        {
	        if (shs.get(j).isa)
            {
		        shs.get(j).shellSurface.toplevel.sendConfigure(Qt.size(0,0),[-6,h,shs.get(shs.count-1).isa?1:0,++output.confcount]);
		        break;
	        }
	    }
	    
	    //shs.get(shs.count-1).shellSurface.toplevel.sendConfigure(Qt.size(0,0),[-6,h,shs.get(j).isa],++output.confcount);
    }
	function is_window_active(winname,appname)
	{
	    var uid = -1;
		var i;
		var j;

		for (j=0;j < output.screens.length; j++){
			var shs = output.screens[j].shellSurfaces;
		    for (i=0;i < shs.count; i++){
                //print("window  ",winname,shs.get(i).shellSurface.toplevel.title,shs.get(i).title);
				if (winname != "" && (shs.get(i).shellSurface.toplevel.title.includes(winname) || shs.get(i).title.includes(winname))){
					uid = j;
					break;
				}
				if (appname != "" && shs.get(i).shellSurface.toplevel.appId == appname){
					uid = j;
					break;
				}
			}
			if (uid >=0)
				break;
		}
		print("window is ",(uid>=0)?"active":"not active");
		return uid;
		
	}
    function is_window_android(title,app)
    {
        if ((title.includes(".") && !title.includes("DISPLAY_ID=")) || (app!=undefined && app.includes("android")) || title.includes(waydroid)){
			return true;
	    }
        else
          return false;
    }        
    function is_androidstack(uid )
    {
	    var shs = output.screens.length >0?output.screens[uid].shellSurfaces:null;
	    var isandroidstack = false;
	    var i;

		if (shs == null)
			return;
	    for (i=0;i < shs.count; i++)
        {
	        if (shs.get(i).shellSurface.toplevel.title.includes("android") &&
				shs.get(i).shellSurface.toplevel.title.includes("##1")){
				isandroidstack = true;
				break;
	        }
	    }
	    return isandroidstack;
    }
    function show_from_other (title )
    {
	    var shs;
	    var i ;
	    var j ;
	    var e ;
	    var isa;
	    var tl = [];
	    var s = [2];
	    var index = -1;
	    var is;
	    var isandroidstack;

        if (output.screens.length == 1)
           return;

        shs  = output.screens[1-uid].shellSurfaces;
	    if (shs == undefined)
	       return;
	    isandroidstack = is_androidstack(1-uid);
        
	    s[1] = tl[1] = "";
	    for (j=0;j < shs.count;j++){
	    
	    e = shs.get(j).shellSurface;
	    isa = shs.get(j).isa;
	    if (isa)
        {
	        for (i=0;i < 2;i++){
		    if (i==0){
		        s[0] = title;
		        tl[i] = title.split("tpm_");
		    }
		    else {
		        s[1] = e.toplevel.title;
		        tl[i] = e.toplevel.title.split("tpm_");
		    }
		    //print("tl size ",i," ", tl[i]);
		    if (tl[i].length == 1)
				s[i] = tl[i][0];
		    else if (tl[i].length > 1){
				s[i] = tl[i][1];
				tl[i] = tl[i][1].split("##");
				s[i] = tl[i][0];
		    }
		    //print("str ",i," ",s[i]);
	        }
	        if (s[0].includes(s[1])){
				if (isandroidstack && shs.get(j).shellSurface.toplevel.title.includes("##0")){//ignore
					return;
				}
			    print ("found same window on disp ",1-uid);
                if (shs.get(shs.count - 1).isa){//only if top on another screen is android window already
			      shs.move(j,shs.count-1,1);
			      index = shs.count-1;
                }
				break;
	        }
	    }
        }
        for (j=0;j < shs.count - 1 && index != -1;j++)
        {
            if (shs.get(j).isa)
            {
    	        shs.get(j).shellSurface.toplevel.sendConfigure(Qt.size(0,0),[-1,-2,++output.screens[1-uid].confcount]);		
	        }
        }
        if (index != -1)
        {
    	    shs.get(shs.count - 1).shellSurface.toplevel.sendConfigure(Qt.size(0,0),[-3,-5,++output.screens[1-uid].confcount]);//no need to bring to front
        }
	    //print("surface os ",output.screens[1-uid].shellSurfaces.get(0).shellSurface.toplevel.title)
    }
    function run_really_android_process()
    {
        if (cmdl != "" && appnamel != "")
        {
            var error_id;
            
            print("really starting ",cmdl);
            error_id = gpqml.run_android_process(cmdl,appnamel,-1);
            if (error_id){
                print ("could not yet start ",cmdl);
                //return -1;
            }
            if (error_id == 0){
				cmdl = "";
				appnamel = "";
			}
		}
		msgerror_hide();
		android_ui_startup = false;
		output.android_ui_active = true;
		if (output.screens.length > 1)
		{
			output.screens[1-uid].msgerror_hide();
			output.screens[1-uid].android_ui_startup = false;
			output.screens[1-uid].android_ui_active = true;//just to be sure
		}
        output.androidReady();
        return 0;
    }
    function run_android_process_common(cmd,appname)
    {
       if (android_ui_startup)
            return;
        if (!android_ui_active)
        {
            var msg = "Android is starting ...";
            print("starting zygote service");
            msgerror(msg);
            if (output.screens.length > 1)
				output.screens[1-uid].msgerror(msg);
            gpqml.run_process("systemctl restart zygote","zygote","",-1);
            cmdl = cmd;
            appnamel = appname;
            android_ui_startup = true;
			
            if (output.screens.length > 1)
				output.screens[1-uid].android_ui_startup = true;
            return;
        }
    }
    function run_android_process(cmd,appname,raise_app,display_id)
    {
        run_android_process_common(cmd,appname);
        print("starting ",cmd);
		if (cmd != "" && appname != ""){
			if (appname != "" && appname != undefined){
				var uid;

				uid = is_window_active(appname,"");
				if (uid >=0){
					output.screens[uid].raise_window(appname);
					return;
				}
			}
			gpqml.run_android_process(cmd,appname,raise_app,display_id);
		}
    }
	function process(isnativeonly,winname,appname)
	{
		var shs = output.shellSurfaces;
		var app;
		var isandroidstack = false;
		var isprevtopnative = true;
		var i;
		var j;
		var rshs = null;
		var obj;
		var stdid = 0;

		if (shs.count == 0)
			return;
		isandroidstack = is_androidstack(uid);
		print("top ",output.shellSurfaces.count," ",(shs.count > 0)?shs.get(shs.count-1).shellSurface.toplevel.title:"");
							
		if (shs.count > 0){
			app = shs.get(shs.count-1).shellSurface.toplevel.appId;
			if (is_window_android(shs.get(shs.count-1).shellSurface.toplevel.title,app)){
				isprevtopnative = false;
			}
		}
		if (isnativeonly && isprevtopnative){
			print("requested next nativeonly got top  ",shs.get(shs.count-1).shellSurface.toplevel.title);
			for (j=0;j < shs.count;j++){//block input
				if (shs.get(j).isa){
					shs.get(j).shellSurface.toplevel.sendConfigure(Qt.size(0,0),[-1,-2,++output.confcount]);
				}
			}
			/*
			  obj = shs.get(shs.count-1);
			  shs.insert(0,obj);
			  shs.remove(shs.count-1);
			  obj = shs.get(0);
			  shs.insert(shs.count,obj);
			  shs.remove(0);
			*/
			return;
		}       
        
		print("nb surface ",output.shellSurfaces.count,"isprevtopnative ",isprevtopnative);
		for (i=shs.count-2;i >= 0; i--) {
			print("surface m ",shs.get(i).shellSurface.toplevel.title,shs.get(i).shellSurface.toplevel.appId , appname);						    
								
			stdid = 0;
			if (shs.get(0).shellSurface.toplevel.title.includes("tpm_statusDlg")){
				stdid = 1;
			}
			if (winname != "" || appname != ""){
				if (winname != "" && !shs.get(i).shellSurface.toplevel.title.includes(winname) && !shs.get(i).title.includes(winname))
					continue;
				else if (appname != "" && shs.get(i).shellSurface.toplevel.appId != appname)
					continue;
				else {
					print("found window ",shs.get(i).shellSurface.toplevel.title, " will raise");
					stdid = i;									   
				}
			}
			if (isnativeonly && shs.get(stdid).isa && shs.count > 0){
				print("requested next nativeonly got  ",shs.get(stdid).shellSurface.toplevel.title);	
				if (stdid < (shs.count - 1)){
					stdid = stdid + 1;
					print("requested next + 1 nativeonly got  ",shs.get(stdid).shellSurface.toplevel.title);	
				}
		    }
		    obj = shs.get(stdid);
            for (var i=0;i < arrdf.length; i++){
              if (obj.shellSurface.toplevel.title.includes(arrdf[i].raise_app) || obj.title.includes(arrdf[i].raise_app)){
               obj.isignoretoppanel = arrdf[i].isignoretoppanel;
               break;
              }
            }
			shs.insert(shs.count,obj);
			shs.remove(stdid);
		
			print("surface  ",shs.get(shs.count-1).shellSurface.toplevel.title,shs.get(shs.count-1).shellSurface.toplevel.appId);
                                
			rshs = shs.get(shs.count-1).shellSurface;
								
			if (rshs.toplevel.title.includes("tpm_statusDlg")){
				rshs = null;
				continue;
			}
								
			if (isandroidstack && rshs.toplevel.title.includes("##0")){
				rshs = null;
				continue;
			}
								
			break;
		}
		if (rshs != null){
			for (j=0;j < shs.count;j++){//we can have statusdlg at pos j=0
				if (shs.get(j).isa){
					shs.get(j).shellSurface.toplevel.sendConfigure(Qt.size(0,0),[-1,-2,++output.confcount]);
					break;
				}
			}
			app =  rshs.toplevel.appId;
		    print("top surface ",rshs.toplevel.title,"/",app);           
			if (is_window_android(rshs.toplevel.title,app)){
				rshs.toplevel.sendConfigure(Qt.size(0,0),[-3,-4,++output.confcount]);
				if (!isandroidstack)
					show_from_other(rshs.toplevel.title);
			}
			else { //native top window we can prepare on foreground next top android window									
					for (i=0;i<=shs.count-2; i++) {
						rshs = shs.get(i).shellSurface;//if native window always put status dlg on top also
						if (rshs.toplevel.title.includes("tpm_statusDlg")){
							//obj = shs.get(i);
							//shs.insert(shs.count,obj);
							//shs.remove(i);
							shs.move(i,shs.count-2,1);
							print("top1 ",shs.get(shs.count-1).shellSurface.toplevel.title);
							break;
						}
					}									
				for (i=0;i<=shs.count-2; i++) {
					if (shs.get(i).isa){//before was android app
						var ti = [];	
						var name ;
						ti = shs.get(i).shellSurface.toplevel.title.split("_replace");
						if (ti.length > 0)
							name = ti[0];
						else
							name = shs.get(i).shellSurface.toplevel.title;
						//gpqml.run_android_process_by_pkg(name);
						//print("preparing in background android window with ",name);
						break;
					}
				}
			}
			/*
			  if (!shs.get(shs.count-1).isfullscreen){
			  db.height = bottomh;
			  }
			  else {
			  db.height = 0;
			  }
	     	*/
            suspend_window(shs.get(shs.count-1),false);
            for (i=0;i<=shs.count-2; i++) {
              suspend_window(shs.get(i),true);
            }
		}
	}//process
    function createObject(parent)
    {
        var component;
        var obj;


        obj = gpqml.load_qml_window("tpm_msgDlg2");
        return obj;
    }
    function msgerror_hide()
    {
        bd.height = 0;
        bd.on_new_text("");
        background.height = Screen.height - db.height;
    }
    function msgerror(msg)
    {
        background.height = 0
        bd.on_new_text(msg);
        bd.height = Screen.height - db.height
    }
    function showlogin()
    {
        background.height = 0;
        db.height = 0;
        login.height = Screen.height;
    }
    function hidelogin()
    {
        login.height = 0;
        db.height = bottomh;
        background.height = Screen.height - db.height;        
    }
    function removesurface(id)
    {
            var shs = output.shellSurfaces;
            shs.remove(id);
            print("remove ",shs.count);
            //gpqml.sleep(70);    
    }
    // During development, it can be useful to start the compositor inside X11 or
    // another Wayland compositor. In such cases, set sizeFollowsWindow to true to
    // enable resizing of the compositor window to be forwarded to the Wayland clients
    // as the output (screen) changing resolution. Consider setting it to false if you
    // are running the compositor using eglfs, linuxfb or similar QPA backends.
    //sizeFollowsWindow: output.isNestedCompositor
    window: Window {
	    id: wnd
        width:  gwidth
        height: gheight
        visible: true
		   
        WaylandMouseTracker {
            id: mouseTracker
            anchors.fill: parent
            
            // Set this to false to disable the outer mouse cursor when running nested
            // compositors. Otherwise you would see two mouse cursors, one for each compositor.
            windowSystemCursorEnabled: output.isNestedCompositor

            GenericModal {
                id : bd
                height: 0
                width: gwidth
                close: false
                abort: false
                back: false
                ok: false
                busy: true
                function on_new_text(msg)
                {
                    message = msg;
                }
                Component.onCompleted: {
                }
                
                MouseArea {
                    anchors.fill: parent
                    onClicked: {
                        //msgerror_hide();
                    }
                }
            }
            Login {
                id : login
                height: 0
                width: gwidth
                backfunc:
                function(username,password){
                    if (gpqml.check_password(username,password))
                       hidelogin();
                }
            }
            Image {
                id: background
                //anchors.fill: parent
                height: gheight - db.height
                width: gwidth
                anchors.bottom: db.top
                fillMode: Image.Tile
                //source: "qrc:/images/background.jpg"
                smooth: true
                Connections {
                        target: output
                         onShow_panel : {
                            if (isshow){
                                output.sizeChanged(gwidth,gheight,!tam.direction);
			                    db.height = bottomh;
			                    background.height = gheight - db.height;
						        notify_resize(background.height);
                            }    
                        }
                }
		        TouchArea {
		            id: tam
		            direction: 1
					onSizeChanged : {
			            output.sizeChanged(w,h-db.height,!direction);
			            db.height = bottomh;
			            background.height = gheight - db.height;
						notify_resize(background.height);
		            }
              Repeater {
                model: output.shellSurfaces//
                //anchors.bottom: db.top
                id: rep
                // Chrome displays a shell surface on the screen (See Chrome.qml)
                Chrome {
                	bottombtn : db
                	pwin: output
                	uid : output.uid
                	bottombtnst : output.bottomh;
                  shellSurface: model.shellSurface//modelData
                  isignoretoppanel: model.isignoretoppanel;
                  /*
                    TapHandler {
                    //grabPermissions : PointerHandler.TakeOverForbidden
    	    		      onTapped: {
    	    			    print ("touch win");
    	    		      }
    			          }
			            */
									onDestroyAnimationFinished: {
										var i = 0;
										var j = 0;
										var id = index;
										var shs = output.shellSurfaces;
										var title;
			              
										print("v ",id,shs.get(id).title);
										title = shs.get(id).title;
										if (count_destroy == 0 && (title.includes(launcher) || title == waydroid))
										{
    									android_ui_active = false;
											if (output.screens.length > 1)
												output.screens[1-uid].android_ui_active = false;//just to be sure
											run_really_android_process();
											is_android_ui_first_window = true;
											is_shown_launcher = false;
											is_shown_asettings = false;
											count_destroy = count_destroy + 1;
											print("setting android_ui_startup to false");
										}
										removesurface(id);    
										for (i=shs.count-1; i>=0;i--)
										{
											var app;
											var shse = shs.get(i);									
											if (shse.shellSurface == undefined)
                      {
												continue;
											}
                      print("remove1 ",shse.shellSurface.toplevel.title);
											app = shse.shellSurface.toplevel.appId;
											if (output.is_window_android(shse.title,app))
                      {
												shse.shellSurface.toplevel.sendConfigure(Qt.size(0,0),[-3,-4,++output.confcount]);
											}
											print("new top ",shse.title,shse.isfullscreen,app);
											if (shse.title.includes(output.launcher) || shse.title == "waydroid")
											{
												output.run_really_android_process();//we may need this if start zygote on demand!!!
											}
											/*
												if (!shse.isfullscreen){
												bottombtn.height = output.bottomh;
												}
												else {
												bottombtn.height = 0;
												}
											*/
											if (shse.isfirsta)
												output.istopa = true;
											else
												output.istopa = false;
											if (shse.shellSurface.toplevel.title.includes("tpm_statusDlg")){
												shs.move(i,i-1,1);
											}
											
											break;
										}
                  }
						Component.onCompleted : {
              model.isfullscreen = isfullscreen;                               
			      }
                }//chrome
              }//repeater
            }//toucharea
            }//image
            BottomButtonsBg {
				id: db
				height: bottomh
				source: "images/grey-textured.jpg"
				//horizontalTileMode: BorderImage.Stretch
				//verticalTileMode: BorderImage.Stretch
				visible: true				
				//anchors.bottom: output.bottom
				y : gheight
				property int sz: 0                
				transform: Scale {xScale: 800/600;/*yScale: 1280/1024;*/origin.y: background.height}

                Connections {
                    target: output
                    onShow_panel : {
                        if (!isshow){
                         output.sizeChanged(gwidth,gheight,!ta.direction);
					     db.height = 0;
					     background.height = gheight;
					     notify_resize(background.height);                                
                        }    
                    }
                }
                function load_desktop_files ()
                {
                    var i;
                    var j;
                    var ex;
                    var s;

                    for (i=0;i < arrdynb.length; i++)
                       arrdynb[i].destroy();
                    arrdynb = [];
				    print ("z ",db.z," android_ui_startup ",android_ui_startup);
				    sz = db.z;
                    for (i=0;i < arrdf.length; i++){
                       print("loading component ", arrdf[i].name);
                    ex = "";
                    for (j=0;j < arrdf[i].exec.length; j++){
                        ex = ex + '\n gpqml.run_process(\"' + arrdf[i].exec[j] + '\",\"\",\"'+ arrdf[i].raise_app +'\",'+arrdf[i].display_id+');'                        
                    }
                    for (j=0;j < arrdf[i].exec_a.length; j++){
                        ex = ex + '\n run_android_process(\"' + arrdf[i].exec_a[j] + '\",\"'+ arrdf[i].appname +'\",\"'+ arrdf[i].raise_app +'\",'+arrdf[i].display_id +');'                    
                    }
                    for (j=0;j < arrdf[i].exec_js.length; j++){
                        ex = ex +  '\n ' +  arrdf[i].exec_js[j];                    
                    }
                    s = 'import QtQuick 2.15;
                     import editec.base 1.0;
                     ButtonBottom {
					    id: btn_' + i + '
                        face: "' + arrdf[i].icon +'"
                        enabled: ' + ((!android_ui_active && arrdf[i].exec_a.length)?false:true) + ' 
                        visible: true
                        pressandholdinterval: 2000 
					    y: 0
					    x: ' + ((arrdf[i].pos_x == -1)?(output.bottomh*(i)):arrdf[i].pos_x) +'
                        Connections {
                          target: output
                            onAndroidReady : {
                                print(\"onAndroidReady btn \",'+i+')
                                btn_'+i+'.enabled = true;
                            }
                        }    
                        onClicked: {'
                           + ex +
                        '}
                        onPressandhold: {
                            kill_window('+i +'); 
                        }        
                       }'
                       //print("exec ",ex);
                       //print("s ",s)
                       var dynamicObject = Qt.createQmlObject(s,ta,'fO_'+ i);
                       arrdynb.push(dynamicObject);
                    }         
                }
				Component.onCompleted : {
                   load_desktop_files();                    
				}
				TouchArea {
				    id: ta
			        direction : 0
				    onSizeChanged : {
					    output.sizeChanged(w,h,!direction);
					    db.height = 0;
					    background.height = gheight;
					    notify_resize(background.height);
				    }
                    Connections {
                        target: output
                        onAndroidReady : {
                            /*    
                            btn_android.enabled = false;
                            btn_chrome.enabled = true;
                            btn_vlc.enabled = true;
                            print ("onAndroidReady")
                            */
                            if (output.uid == 0)
                               gpqml.sig_zygote_running(2);
                        }
                    }
                    Connections {
                        target: gpqml
                         onSig_desktopfiles_changed : {
                            arrdf = gpqml.load_desktop_files(uid + 1);        
                            db.load_desktop_files();
                        }
                    }
                    /*
				    ButtonBottom {
					    id: btn_android
					    y: 0//15
						x: 0
						//width:bottomh; height:bottomh
					    enabled: true//android_ui_active
						face: "android"//back
					    onClicked: {
						    print("ext display ",gpqml.get_ext_displayid());
					        //run_android_process("am start-activity -n com.android.music/.MusicBrowserActivity --display 0","com.android.music");
							run_android_process("","",-1);
							
					    }
				    }
                    
					ButtonBottom {
					    id: btn_chrome
					    y: 0
						anchors.left: btn_android.right
					    enabled: false
						face: "chrome"
					        onClicked: {
						    print("ext display ",gpqml.get_ext_displayid());						
                            run_android_process("rm -rf /data/data/com.android.chrome/app_tabs/0",-1);
					        run_android_process("am start -n com.android.chrome/com.google.android.apps.chrome.Main -d https://premierbetzone.com/cm/ --display " + gpqml.get_second_displayid(),"com.android.chrome",-1);
					    }
				    }
                    ButtonBottom {
					    id: btn_vlc
					    y: 0
						anchors.left: btn_chrome.right
					    enabled: false
						face: "vlc"
					    onClicked: {
                              run_android_process("killall org.videolan.vlc",-1);            
                              run_android_process("am start -n org.videolan.vlc/org.videolan.vlc.gui.video.VideoPlayerActivity -d file:///home/root/dune-final-trailer_h1080p.mov --display "+ gpqml.get_ext_displayid(),"org.videolan.vlc",-1);    						    
					    }
				    }                   
                    ButtonBottom {
					    id: btn_scr
					    y: 0//15
                        face: "scr1"
						anchors.left: btn_vlc.right
					    visible : (gpqml.get_config("screenshot_button_visible","") == "true")?true:false
					    onClicked: {
                           take_screenshot();			    
					    }
				    }
                    
				    ButtonBottom {
					    id: btn_back
					    y: 0//15
					    x: parent.width - bottomh
					    face: "sysbarback"

						Component.onCompleted: {
						}						
						onClicked: {
							process(false,"","");
						}
                        
					    
					}//buttonbuttom
                    */
				}//toucharea
		    }
            
            // Virtual Keyboard
           
            
            // Draws the mouse cursor for a given Wayland seat
            /*
            WaylandCursorItem {
                inputEventsEnabled: false
                x: mouseTracker.mouseX
                y: mouseTracker.mouseY
                seat: output.compositor.defaultSeat
            }
            */
            TapHandler {
    	        onTapped: {
    	    	    screen_touched()
    	        }
    	    }
            //not working on desktop qt5
            onMouseTapped :{
    	        screen_touched()
            }
        }//mousetracker
        Shortcut {
            sequence: "Ctrl+Alt+Backspace"
            onActivated: Qt.quit()
        }
    }//window
}
