pragma Singleton
import QtQuick 2.4
import QtQuick.Window 2.2

Item {
    id : smainsc
    property bool isNestedCompositor: Qt.platform.pluginName.startsWith("wayland") || Qt.platform.pluginName === "xcb"
    property double w : 1.00
    property double h : 1.00
    property int bwidth:600
    property int bheight: 1024;
    property int bpheight: 0;
    property int panelwid:1
    property int gwidth:  !isNestedCompositor?Screen.width:720
    property int gheight: !isNestedCompositor?Screen.height:1280

    Component.onCompleted: {
        w = gwidth / bwidth;
        h = gheight / bheight;
    }
    function get_coeff(s,isw)
    {
        var coeff=1.00 ;

       if (!isw){
           if (h <= 1.25)
               coeff = 1.00/h;
           else if (h > 1.20 && h < 2.20)
               coeff = 2.00/h;
           else if (h > 2.20 && h < 3.00)
               coeff = 3.00/h;
       }
       //print("coeff ", coeff); 
       return coeff;
    }
    function get_w(idi)
    {
        var r,coeff;
        coeff = get_coeff(idi.toString(),1);
        r = w*coeff;
        return r;
    }
    function get_h(idi)
    {
        var r,coeff;
        coeff = get_coeff(idi.toString(),0);
        r = h*coeff;
        return r;
    }
    function get_hpanel()
    {
        var r,coeff;
        coeff = get_coeff("TopBar",0);
        r = h*coeff;
        return r;
    }
}
