import QtQuick 2.0

//////////////////////////////////////
// generic component used for all modal buttons
// example usage: ModalButton{face:"close"}
//////////////////////////////////////

Rectangle {
    id:main

    property string face
    signal clicked

    width:170; height:100

    x: tap.pressed ? 1 : 0; y: tap.pressed ? 3 : 0

    color: {
        switch(face) {
        case "abort":   return(tap.pressed ? "#a31b18" : "#d72420"); break;
        case "ok":      return(tap.pressed ? "#274e73" : "#3971a6"); break;
        case "back":    return(tap.pressed ? "#274e73" : "#3971a6"); break;
        case "print":   return(tap.pressed ? "#256b25" : "#0f9952"); break;
        }
    }

    Image {
        anchors.centerIn: parent;
        source: "./images/modal_"+face+".png"
    }

    MouseArea {
        id: tap
        anchors.fill: parent
        onClicked: main.clicked()
    }
}
