import QtQuick 2.15
import QtQuick.Controls 2.15
import QtQuick.Window 2.15
import QtQuick.Layouts 1.11

Rectangle {
         id: base
         property var backfunc
         property string username;
         property string password;

         ColumnLayout {
             id: colLayout1
             height: ScaleE.bheight - keyboardAlpha.height /*- bottombuttonsbg.height*/
             anchors.bottom: keyboardNumerical.top
             spacing: 20            
             anchors.horizontalCenter: parent.horizontalCenter
             //anchors.verticalCenter: parent.verticalCenter
             Item { Layout.fillHeight: true }
             Label {
                    Layout.alignment: Qt.AlignHCenter;
                    font.pixelSize: 48//24
                    color: "black"
                    text: ("Username")
             }
             Rectangle {
                 id:login
                 radius: 24
                 border.width :1
                 border.color : "black"
                 Layout.preferredWidth:336;
                 Layout.preferredHeight:80;
                 Layout.alignment: Qt.AlignHCenter;
                     TextInput {
                         id: txtlogin      
                         anchors{fill: parent; leftMargin:20; topMargin:10; rightMargin:0; }
                         Layout.alignment: Qt.AlignVCenter
                         width:parent.width; height:parent.height
                         font.pixelSize: 44//24
                         focus:true

                         onEditingFinished: {
                            username = text;
                         }
                         onActiveFocusChanged: {
                             if (activeFocus){
                                 keyboardNumerical.visible = true;
                                 keyboardAlpha.visible = false;
                             }
                         }    
                     }
             }
             Label {
               Layout.alignment: Qt.AlignHCenter;
               font.pixelSize: 48//24
               color: "black"
               text: ("Password")
             }
             Rectangle {
                 id:pwd
                 radius: 24
                 border.width :1
                 border.color : "black"
                 Layout.preferredWidth:336;
                 Layout.preferredHeight:80;
                 Layout.alignment: Qt.AlignHCenter;
                      TextInput {
                         id: txtpwd         
                         anchors{fill: parent; leftMargin:20; topMargin:10; rightMargin:0; }
                         Layout.alignment: Qt.AlignVCenter
                         width:parent.width; height:parent.height
                         font.pixelSize: 44//20
                         echoMode: TextInput.Password 
                         focus:false
                         onEditingFinished: {
                            password = text;
                          }
                         onActiveFocusChanged: {
                             if (activeFocus){
                                 keyboardNumerical.visible = false;
                                 keyboardAlpha.visible = true;
                             }
                         }  
                     }
             }
             Item { Layout.fillHeight: true }
       
             Component.onCompleted : {
                 txtlogin.forceActiveFocus();
             }
     }    
     AdminKeyboardNumerical {
        id: keyboardNumerical
        modeSwitch: true
        visible: true
        anchors.bottom: parent.bottom 
        //decimal: false
        transform: Scale {xScale: ScaleE.get_w(keyboardNumerical);yScale: ScaleE.get_h(keyboardNumerical)}
          onClicked: {
             if(key == "switchKeyboard") {
                keyboardAlpha.visible = true
                keyboardNumerical.visible = false
                return
              } else if(key == "validate") {
                 backfunc(txtlogin.text,txtpwd.text);
                 txtpwd.text = "";
                 txtlogin.text = "";
                 txtlogin.forceActiveFocus();
             } else {
             handle_key(getfocus(), key)
             }
         }
     }
     AdminKeyboardAlpha {
            id: keyboardAlpha
            width: ScaleE.bwidth
            anchors.bottom: parent.bottom
            modeSwitch: true
            visible: false

            transform: Scale {xScale: ScaleE.get_w(keyboardAlpha);yScale: ScaleE.get_h(keyboardAlpha)}
            onClicked: {
                if(key == "switchKeyboard") {
                     keyboardAlpha.visible = false
                     keyboardNumerical.visible = true
                    return
                } else if(key == "validate") {
                   backfunc(txtlogin.text,txtpwd.text);
                   txtpwd.text = "";
                   txtlogin.text = "";
                   txtlogin.forceActiveFocus();
                } else {
                    handle_key(getfocus(), key)
                }
            }
    }
    /*
     BottomButtonsBg {
        id: bottombuttonsbg
        anchors.bottom: parent.bottom
        width: ScaleE.bwidth
        //height: ScaleE.bheight 
        transform: Scale {xScale: ScaleE.get_w(bottombuttonsbg);yScale: ScaleE.get_h(bottombuttonsbg)}
        ButtonBottom {
            id:btnok
            y: 0
            x:ScaleE.bwidth  - 150;
            face: "ok"
            pressandholdinterval: 2000 //need to fill it in
            onClicked: {
                backfunc(txtlogin.text,txtpwd.text);
            }
         }
    }
    */
     function handle_key(txt, key) {
                if(txt === null) {
                    return
                }
                if(txt.selectionStart != txt.selectionEnd) {
                    var start = txt.selectionStart
                    txt.remove(txt.selectionStart, txt.selectionEnd)
                    if(key == "backspace" || key == "clear" || key == "validate") {
                        txt.deselect()
                        return
                    }
                    txt.insert(start, key)
                    txt.deselect()
                } else {
                    if(key == "backspace") {
                        if(txt.cursorPosition > 0) {
                            txt.remove(txt.cursorPosition - 1, txt.cursorPosition)
                        }
                        txt.deselect()
                        return
                    }
                    if(key == "clear") {
                        txt.text = ""
                        txt.deselect()
                        return
                    }
                    if(key == "validate") {
                        return
                    }
                    txt.insert(txt.cursorPosition, key)
                    txt.deselect()
                }
            }

            function getfocus() {
                if(txtlogin.activeFocus) {
                    return txtlogin;
                }
                if(txtpwd.activeFocus) {
                    return txtpwd;
                }
                return null
            }
}
