import QtQuick 2.0

//////////////////////////////////////
// object for alpha keyboard
// possible returns: "A"-"Z", "backspace", "clear", "validate", "switchKeyboard"
//////////////////////////////////////

Item{
    id:main
    property alias modeSwitch: modeSwitchButton.visible
    property alias copy:textCopy.text
    property alias background: background.visible
    
    signal clicked(string key)

    width:600; height:440; y:404

    KeyboardBg{id:background; anchors.fill: parent; visible:true}

    Flow {
        x:15; y:30; width:560

        //textfield
        Item {
            width:445; height:80;
            visible: true
            InputBg{
                anchors{fill:parent;leftMargin:3; topMargin:12; rightMargin:10; bottomMargin:18}
                Text {
                    id: textCopy
                    anchors{fill: parent; leftMargin:10; topMargin:5; rightMargin:10}
                    clip:true
                    font{family:"Open Sans";bold:true;pixelSize:28}
                    color: "#000000"
                    horizontalAlignment: contentWidth < 412 ? Text.AlignLeft : Text.AlignRight
                }
            }
        }

        //buttons
        ButtonSmallBackspace {onClicked: main.clicked("backspace");onPressAndHold: main.clicked("clear")}
        ButtonLetter {label: "Q"; onClicked: main.clicked(label)}
        ButtonLetter {label: "W"; onClicked: main.clicked(label)}
        ButtonLetter {label: "E"; onClicked: main.clicked(label)}
        ButtonLetter {label: "R"; onClicked: main.clicked(label)}
        ButtonLetter {label: "T"; onClicked: main.clicked(label)}
        ButtonLetter {label: "Y"; onClicked: main.clicked(label)}
        ButtonLetter {label: "U"; onClicked: main.clicked(label)}
        ButtonLetter {label: "I"; onClicked: main.clicked(label)}
        ButtonLetter {label: "O"; onClicked: main.clicked(label)}
        ButtonLetter {label: "P"; onClicked: main.clicked(label)}
        Item {width:20; height:80;}
        ButtonLetter {label: "A"; onClicked: main.clicked(label)}
        ButtonLetter {label: "S"; onClicked: main.clicked(label)}
        ButtonLetter {label: "D"; onClicked: main.clicked(label)}
        ButtonLetter {label: "F"; onClicked: main.clicked(label)}
        ButtonLetter {label: "G"; onClicked: main.clicked(label)}
        ButtonLetter {label: "H"; onClicked: main.clicked(label)}
        ButtonLetter {label: "J"; onClicked: main.clicked(label)}
        ButtonLetter {label: "K"; onClicked: main.clicked(label)}
        ButtonLetter {label: "L"; onClicked: main.clicked(label)}
        Item {width:40; height:80;}
        ButtonLetter {label: "Z"; onClicked: main.clicked(label)}
        ButtonLetter {label: "X"; onClicked: main.clicked(label)}
        ButtonLetter {label: "C"; onClicked: main.clicked(label)}
        ButtonLetter {label: "V"; onClicked: main.clicked(label)}
        ButtonLetter {label: "B"; onClicked: main.clicked(label)}
        ButtonLetter {label: "N"; onClicked: main.clicked(label)}
        ButtonLetter {label: "M"; onClicked: main.clicked(label)}
        ButtonSmallValidate{onClicked: main.clicked("validate")}
        Item {width:96; height:80;}
        ButtonSpacebar{onClicked: main.clicked(" ")}
        Item {width:56; height:80;}
        ButtonKeyboardMode {id: modeSwitchButton; label: "123"; visible: false; onClicked: main.clicked("switchKeyboard")}
    }
}
