import QtQuick 2.0

//////////////////////////////////////
// used for displaying various messages
//////////////////////////////////////

Rectangle {
    id:main

    property alias message:message.text
    property alias headerImage:headerImageContainer.source
    property alias image:imageContainer.source
    property alias playing:imageContainer.playing

    property alias close:closeButton.visible

    property alias abort:abortButton.visible
    property alias back:backButton.visible
    property alias ok:okButton.visible

    property alias busy:busy.visible

    signal clicked(string action)


    width:600;
    height:984
    color: "#88000000"

    Rectangle {
        id: background
        anchors{fill:parent;margins:10}
    }

    Rectangle {
        id:closeButton
        visible:false;
        width:55; height: 55
        anchors{right:background.right;rightMargin:15;top:background.top;topMargin:15}
        color:tap.pressed ? "#555555" : "#808080"

        Image {
            source: "images/small_close.png"
            anchors.centerIn: parent
        }

        MouseArea {
            id:tap
            anchors.fill:parent
            onClicked: main.clicked("close");
        }
    }

    Rectangle {
        id:content
        width:background.width;
        x:background.x;

        y:(close ? closeButton.height+closeButton.y : background.y);
        height:background.height - (close ? closeButton.height + closeButton.y : 0) - (main.abort || main.back || main.ok ? 104 : 0)

        Column {
            id:column

            property var spaces: 2 + (headerImage!="" ? 1 : 0) + (image!="" ? 1 : 0) + (busy ? 1 : 0)

            anchors.centerIn: parent
            spacing:Math.round((content.height-headerImageContainer.height-message.height-imageContainer.height) / spaces)

            AnimatedImage {
                id:headerImageContainer
                anchors.horizontalCenter: parent.horizontalCenter
                playing: imageContainer.playing
            }

            Text {
                id: message
                anchors.horizontalCenter: parent.horizontalCenter
                width: background.width - 20
                font{family:"Open Sans C";pixelSize: 60}
                horizontalAlignment: Text.AlignHCenter; wrapMode: Text.Wrap
                color:"#d72421"
            }

            AnimatedImage {
                id:imageContainer
                anchors.horizontalCenter: parent.horizontalCenter
            }

            BusyAnimation {
                id:busy
                anchors.horizontalCenter: parent.horizontalCenter
                visible:false
            }
        }

    }

    ModalButton {
        id:abortButton
        visible:false
        face:"abort"
        anchors{left:background.left;leftMargin:15;bottom:background.bottom;bottomMargin:15}
        onClicked: main.clicked(face)
    }

    ModalButton {
        id:backButton
        visible:false
        face:"back"
        anchors{horizontalCenter:background.horizontalCenter;bottom:background.bottom;bottomMargin:15}
        onClicked: main.clicked(face)
    }

    ModalButton {
        id:okButton
        face:"ok"
        visible:false
        anchors{right:background.right;rightMargin:15;bottom:background.bottom;bottomMargin:15}
        onClicked: main.clicked(face)
    }
}
