/****************************************************************************
**
** Copyright (C) 2017 The Qt Company Ltd.
** Contact: http://www.qt-project.org/legal
**
** This file is part of the examples of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:BSD$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** BSD License Usage
** Alternatively, you may use this file under the terms of the BSD license
** as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of The Qt Company Ltd nor the names of its
**     contributors may be used to endorse or promote products derived
**     from this software without specific prior written permission.
**
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick 2.0
import QtQuick.Window 2.15
import QtWayland.Compositor 1.0

ShellSurfaceItem {
 id: chrome
	 property bool isChild: parent.shellSurface !== undefined;
     property var bottombtn
	 property var pwin
	 property int bottombtnst
     property var isfullscreen : false
     property var isignoretoppanel: false
	 property int uid
	 signal destroyAnimationFinished
	 // If the client asks to show popups on this surface, automatically create child ShellSurfaceItems
	 autoCreatePopupItems: true

		 function resize(w,h,isforcefullscreen)
		{
			var title = shellSurface.toplevel.title;
			var app = shellSurface.toplevel.appId;
			var m = 0;
			var btnh = bottombtn.height;
			var pheight;
	
			print("shellsurfaceitem ",title,"/",app,parent.height,"uid",uid,shellSurface.windowGeometry,pwin,"/isignoretoppanel/",isignoretoppanel);
			if ((uid==0 && !title.includes("tpm_statusDlg")  && !title.includes("tpm_updateDlg")  && title != "android" && app != "android" && title != "tpm_android" && app != "tpm_android" && title != "declarative-camera" && !title.includes("org.videolan") && !title.includes("Chromium") && !title.includes("Waydroid") && !isignoretoppanel) || title.includes("tpm_statusDlg2") || title == ""){
				m = 40*1.5;
				moveItem.y = m;    
				//shellSurface.toplevel.sendResizing(Qt.size(parent.width,parent.height - btnh - m));
				print ("moving ",title,parent.height , btnh , m);
			}
			else {
				moveItem.y = 0;
	    
				if (title.includes("org.videolan1") || title.includes("Chromium2")){
					btnh = 0;
					isfullscreen = true;
				}
			}
			pheight = parent.height;
	
			if (!isfullscreen && !isforcefullscreen)
				bottombtn.height = bottombtnst;
			else
				bottombtn.height = 0;
	
			if (!title.includes("tpm_statusDlg") || title.includes("tpm_statusDlg2")){
				print ("yScale b ",transform[0].yScale,pheight,Screen.height);
				if (!isfullscreen)
					transform[0].yScale = (Screen.height - bottombtn.height - m)/(Screen.height - m);
				else {
					if (shellSurface.windowGeometry.height > 0)
						transform[0].yScale = Screen.height/shellSurface.windowGeometry.height;
					else
						transform[0].yScale = Screen.height/pheight;
				}
				print ("yScale a ",transform[0].yScale,parent.height,Screen.height);
				transform[0].origin.x = parent.width / 2;
				transform[0].origin.y = 0;//
			}
			//moveItem.height = 1000;    
		}
    Connections {
	target: pwin
	
		function onSizeChanged(w,h,direction) 
		{
			print("new size ",w,h,shellSurface.toplevel.title);
			resize(w,h,direction);
		}
    }
    Component.onCompleted : {
		resize (Screen.width,Screen.height,bottombtn.height > 1?false:true);
    }
    onSurfaceDestroyed: {
        bufferLocked = true;
        //destroyAnimation.start();
	    destroyAnimationFinished();
    }
    
    transform: [
        Scale {
            id: scaleTransform
            //origin.x: chrome.width / 2
            //origin.y: chrome.height / 2
            //yScale: 0.80
        }
    ]
    
    Connections {
        target: shellSurface

        // some signals are not available on wl_shell, so let's ignore them
        ignoreUnknownSignals: true

        function onActivatedChanged()
        { // xdg_shell only
            if (shellSurface.activated) {
                //receivedFocusAnimation.start();
            }
        }
    }
    
    SequentialAnimation {
        id: destroyAnimation

        ParallelAnimation {
            NumberAnimation { target: scaleTransform; property: "yScale"; to: 2/height; duration: 150 }
            NumberAnimation { target: scaleTransform; property: "xScale"; to: 0.4; duration: 150 }
            NumberAnimation { target: chrome; property: "opacity"; to: chrome.isChild ? 0 : 1; duration: 150 }
        }
        NumberAnimation { target: scaleTransform; property: "xScale"; to: 0; duration: 150 }
        ScriptAction { script: destroyAnimationFinished() }
    }
    
    SequentialAnimation {
        id: receivedFocusAnimation

        ParallelAnimation {
            NumberAnimation { target: scaleTransform; property: "yScale"; to: 1.00; duration: 100; easing.type: Easing.OutQuad }
            NumberAnimation { target: scaleTransform; property: "xScale"; to: 1.00; duration: 100; easing.type: Easing.OutQuad }
        }
        ParallelAnimation {
            NumberAnimation { target: scaleTransform; property: "yScale"; to: 1; duration: 100; easing.type: Easing.InOutQuad }
            NumberAnimation { target: scaleTransform; property: "xScale"; to: 1; duration: 100; easing.type: Easing.InOutQuad }
        }
    }
}
