import QtQuick 2.0

//////////////////////////////////////
// used in admin alpha keyboards
//////////////////////////////////////

Image {
    id:main

    signal clicked
    signal pressAndHold

    width:96; height:80
    source: tap.pressed ? "images/button_shift_dn.png" : "images/button_shift_up.png";

    state: "OFF"

    Image {
        id:face
        anchors{centerIn: parent; verticalCenterOffset: tap.pressed ? 0 : -3}
    }

    MouseArea {
        id: tap
        anchors.fill: parent
        onClicked: main.clicked()
        onPressAndHold: main.pressAndHold()
    }

    states: [
        State {
            name:"OFF"
            PropertyChanges{target:face; source: "images/shift_off.png"}
        },
        State {
            name:"ON"
            PropertyChanges{target:face; source: "images/shift_on.png"}
        },
        State {
            name:"BLOCKED"
            PropertyChanges{target:face; source: "images/shift_blocked.png"}
        }

    ]
}
