import QtQuick 2.0
import "."

//////////////////////////////////////
// used in both numerical and alpha keyboards
// (switches between the two keyboards)
// usage examples: ButtonKeyboardMode {text: "123"} or ButtonKeyboardMode {text: "ABC"}
//////////////////////////////////////

Image {
    id:main

    property alias label: label.text

    signal clicked

    width:128; height:80
    source: tap.pressed ? "images/button_keyboard_mode_dn.png" : "images/button_keyboard_mode_up.png";

    Text {
        id: label
        anchors{centerIn: parent; verticalCenterOffset: tap.pressed ? 0 : -3}
        font{family:"Open Sans";bold:true;pixelSize: 30}
        color: "#000000"
    }

    MouseArea {
        id: tap
        anchors.fill: parent
        onClicked: main.clicked()
        //onPressed: if (SoundE.press) SoundE.press.play()
    }
}
