import QtQuick 2.0
import "."

//////////////////////////////////////
// generic button used for all bottom buttons
// example usage: ButtonBottom{face:"add_entry"}
//////////////////////////////////////

Image {
    id:main
    property int pressandholdinterval;
    property string face    
    signal clicked
    signal pressandhold

    opacity:tap.pressed?0.7:1.0
    width:tap.pressed? 90:parent.height; height:tap.pressed? 90:parent.height
    source:tap.pressed ? "images/button_"+main.face+"_dn.png" : "images/button_"+main.face+"_up.png"

    MouseArea {
        id: tap
        anchors.fill: parent
        onClicked: {
            main.clicked()
        }
        
        onPressAndHold: main.pressandhold()           
    }
    Component.onCompleted : {
        tap.pressAndHoldInterval = main.pressandholdinterval; 
    } 
}
