import QtQuick 2.0

//////////////////////////////////////
// object for numerical keyboard for admin views
// with extra charaters for miscelaneous input fields
//////////////////////////////////////

Item{
    id:main
    property alias modeSwitch: modeSwitchButton.visible
    property alias background: background.visible
    
    signal clicked(string key)

    width:600; height:440; y:404

    KeyboardBg{id:background; anchors.fill: parent; visible:true}

    Flow {
        x:15; y:30; width:560

        ButtonLetter {label: "{"; onClicked: main.clicked(label)}
        ButtonLetter {label: "}"; onClicked: main.clicked(label)}
        ButtonLetter {label: "["; onClicked: main.clicked(label)}
        ButtonLetter {label: "]"; onClicked: main.clicked(label)}
        ButtonLetter {label: "("; onClicked: main.clicked(label)}
        ButtonLetter {label: ")"; onClicked: main.clicked(label)}
        ButtonLetter {label: "<"; onClicked: main.clicked(label)}
        ButtonLetter {label: ">"; onClicked: main.clicked(label)}
        ButtonSmallBackspace {onClicked: main.clicked("backspace");onPressAndHold: main.clicked("clear")}
        ButtonLetter {label: "1"; onClicked: main.clicked(label)}
        ButtonLetter {label: "2"; onClicked: main.clicked(label)}
        ButtonLetter {label: "3"; onClicked: main.clicked(label)}
        ButtonLetter {label: "4"; onClicked: main.clicked(label)}
        ButtonLetter {label: "5"; onClicked: main.clicked(label)}
        ButtonLetter {label: "6"; onClicked: main.clicked(label)}
        ButtonLetter {label: "7"; onClicked: main.clicked(label)}
        ButtonLetter {label: "8"; onClicked: main.clicked(label)}
        ButtonLetter {label: "9"; onClicked: main.clicked(label)}
        ButtonLetter {label: "0"; onClicked: main.clicked(label)}
        Item {width:20; height:80;}
        ButtonLetter {label: "."; onClicked: main.clicked(label)}
        ButtonLetter {label: "|"; onClicked: main.clicked(label)}
        ButtonLetter {label: "\\"; onClicked: main.clicked(label)}
        ButtonLetter {label: "/"; onClicked: main.clicked(label)}
        ButtonLetter {label: "*"; onClicked: main.clicked(label)}
        ButtonLetter {label: "_"; onClicked: main.clicked(label)}
        ButtonLetter {label: "-"; onClicked: main.clicked(label)}
        ButtonLetter {label: "+"; onClicked: main.clicked(label)}
        ButtonLetter {label: "="; onClicked: main.clicked(label)}
        Item {width:40; height:80;}
        ButtonLetter {label: "~"; onClicked: main.clicked(label)}
        ButtonLetter {label: "@"; onClicked: main.clicked(label)}
        ButtonLetter {label: "#"; onClicked: main.clicked(label)}
        ButtonLetter {label: "$"; onClicked: main.clicked(label)}
        ButtonLetter {label: "%"; onClicked: main.clicked(label)}
        ButtonLetter {label: "^"; onClicked: main.clicked(label)}
        ButtonLetter {label: "&"; onClicked: main.clicked(label)}
        ButtonSmallValidate{onClicked: main.clicked("validate")}
        Item {width:40; height:80;}
        ButtonLetter {label: "`"; onClicked: main.clicked(label)}
        ButtonSpacebar{onClicked: main.clicked(" ")}
        Item {width:56; height:80;}
        ButtonKeyboardMode {id: modeSwitchButton; label: "ABC"; visible: false; onClicked: main.clicked("switchKeyboard")}
    }
}
