import QtQuick 2.0

//////////////////////////////////////
// object for alpha keyboard for admin views
// with extra charaters for miscelaneous input fields
//////////////////////////////////////

Item{
    id:main
    property alias modeSwitch: modeSwitchButton.visible
    property alias background: background.visible
    
    signal clicked(string key)

    function shiftClicked() {
        switch (shift.state) {
        case "OFF": shift.state = "ON"; capitalize(); break;
        default:shift.state = "OFF"; decapitalize();
        }
    }

    function shiftPressAndHold() {
        switch (shift.state) {
        case "BLOCKED": shift.state = "OFF"; decapitalize(); break;
        default:shift.state = "BLOCKED"; capitalize();
        }
    }

    function keyClicked(key) {
        clicked(key);
        if (shift.state == "ON") shiftClicked();
    }

    function capitalize() {
        var key = keys.children
        for (var i = 0; i < key.length; ++i) {
            if(key[i].type=="letter") key[i].label = key[i].label.toUpperCase();
        }
    }

    function decapitalize() {
        var key = keys.children
        for (var i = 0; i < key.length; ++i) {
            if(key[i].type=="letter") key[i].label = key[i].label.toLowerCase();
        }
    }


    width:600; height:440; y:404

    KeyboardBg{id:background; anchors.fill: parent; visible:true}

    Flow {
        id:keys
        x:15; y:30; width:560

        ButtonLetter {label: ","; onClicked: keyClicked(label)}
        ButtonLetter {label: "."; onClicked: keyClicked(label)}
        ButtonLetter {label: "?"; onClicked: keyClicked(label)}
        ButtonLetter {label: "!"; onClicked: keyClicked(label)}
        ButtonLetter {label: "\'";onClicked: keyClicked(label)}
        ButtonLetter {label: "\"";onClicked: keyClicked(label)}
        ButtonLetter {label: ":"; onClicked: keyClicked(label)}
        ButtonLetter {label: ";"; onClicked: keyClicked(label)}
        ButtonSmallBackspace {onClicked: main.clicked("backspace");onPressAndHold: main.clicked("clear")}
        ButtonLetter {label: "q"; onClicked: keyClicked(label); type:"letter"}
        ButtonLetter {label: "w"; onClicked: keyClicked(label); type:"letter"}
        ButtonLetter {label: "e"; onClicked: keyClicked(label); type:"letter"}
        ButtonLetter {label: "r"; onClicked: keyClicked(label); type:"letter"}
        ButtonLetter {label: "t"; onClicked: keyClicked(label); type:"letter"}
        ButtonLetter {label: "y"; onClicked: keyClicked(label); type:"letter"}
        ButtonLetter {label: "u"; onClicked: keyClicked(label); type:"letter"}
        ButtonLetter {label: "i"; onClicked: keyClicked(label); type:"letter"}
        ButtonLetter {label: "o"; onClicked: keyClicked(label); type:"letter"}
        ButtonLetter {label: "p"; onClicked: keyClicked(label); type:"letter"}
        Item {width:20; height:80;}
        ButtonLetter {label: "a"; onClicked: keyClicked(label); type:"letter"}
        ButtonLetter {label: "s"; onClicked: keyClicked(label); type:"letter"}
        ButtonLetter {label: "d"; onClicked: keyClicked(label); type:"letter"}
        ButtonLetter {label: "f"; onClicked: keyClicked(label); type:"letter"}
        ButtonLetter {label: "g"; onClicked: keyClicked(label); type:"letter"}
        ButtonLetter {label: "h"; onClicked: keyClicked(label); type:"letter"}
        ButtonLetter {label: "j"; onClicked: keyClicked(label); type:"letter"}
        ButtonLetter {label: "k"; onClicked: keyClicked(label); type:"letter"}
        ButtonLetter {label: "l"; onClicked: keyClicked(label); type:"letter"}
        Item {width:40; height:80;}
        ButtonLetter {label: "z"; onClicked: keyClicked(label); type:"letter"}
        ButtonLetter {label: "x"; onClicked: keyClicked(label); type:"letter"}
        ButtonLetter {label: "c"; onClicked: keyClicked(label); type:"letter"}
        ButtonLetter {label: "v"; onClicked: keyClicked(label); type:"letter"}
        ButtonLetter {label: "b"; onClicked: keyClicked(label); type:"letter"}
        ButtonLetter {label: "n"; onClicked: keyClicked(label); type:"letter"}
        ButtonLetter {label: "m"; onClicked: keyClicked(label); type:"letter"}
        ButtonSmallValidate{onClicked: main.clicked("validate")}
        //Item {width:40; height:80;}
        ButtonShift {id:shift; onClicked: main.shiftClicked(); onPressAndHold: main.shiftPressAndHold()}
        ButtonSpacebar{onClicked: main.clicked(" ")}
        Item {width:56; height:80;}
        ButtonKeyboardMode {id: modeSwitchButton; label: "123"; visible: false; onClicked: main.clicked("switchKeyboard")}
    }
}
